<?php 
session_start();

include("../../../sql_connect.php");
include("functions.php");

$user_data = check_login($dbc);

function build_url($params = []) {
    $base_url = "codex.php";
    $query = array_merge($_GET, $params); // Merge new params with existing ones
    return $base_url . '?' . http_build_query($query);
}

$equip = isset($_GET['equip']) ? $_GET['equip'] : 'warframes';
switch ($equip) {
    case "warframes":
        $table = "`warframes`";
        break;
    case "primaries":
        $table = "`primaries`";
        break;
    case "secondaries":
        $table = "`secondaries`";
        break;
    case "melees":
        $table = "`melees`";
        break;
    default:
        $table = "`warframes`";
        break;
}

$equip_id = isset($_GET['equip_id']) ? intval($_GET['equip_id']) : 0;

$query = "SELECT * FROM $table WHERE ID = $equip_id LIMIT 1";
$result = mysqli_query($dbc, $query);

if ($result && mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
}
?>

<!DOCTYPE html>
<html lang="en">
<?php require("assets/includes/head.html") ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const modCap = document.getElementById('modCap');
    const orokinReactor = document.getElementById('orokinReactor');

    orokinReactor.addEventListener('change', function() {
        if (orokinReactor.checked) {
            modCap.textContent = '60 / 60';
        } else {
            modCap.textContent = '30 / 30';
        }
    });
});
</script>
</head>
<title>New Build - Warpon Prime</title>
        <?php include("assets/includes/header.php"); ?>

        <form class="buildPlate" method="post">
            
            <img src="<?php echo $row['IMAGE_LINK'] ?>" alt="<?php echo $row['NAME'] ?>" class="newBuildImg">
            <div class="buildTitle">
                <h1 class="warpTitle"><?php echo $row['NAME'] ?></h1>
                <div class="formaDiv">
                    <img src="https://wiki.warframe.com/images/thumb/Forma.png/300px-Forma.png?c7d01" alt="forma usage" class="formaImg">
                    <h1 class="formaText">0</h1>
                </div>
                <p class="newBuildDesc">
                    <?php echo $row['DESCRIPTION']; ?>
                </p>
            </div>
            <div class="modList">
                
            </div>
            <div class="newBuildStats">

                <!-- Settings -->

                <div class="newBuildSettingsDesc">
                    <h4 class="newBuildStatDesc" id="modCap">30 / 30</h4>
                    <br>
                    <h4 class="newBuildStatDesc">Orokin Reactor</h4>
                </div>

                <div class="newBuildSettingsAns">
                    <input id="creatBuild" class="buttony" type="submit" value="Create Build">
                    <br>
                    <input id="orokinReactor" type="checkbox" value="Create Build">
                </div>

                <!-- Abilities -->

                <div class="abilityModDesc">
                    <h4 class="newBuildStatDesc">Strength</h4>
                    <h4 class="newBuildStatDesc">Duration</h4>
                    <h4 class="newBuildStatDesc">Efficiency</h4>
                    <h4 class="newBuildStatDesc">Range</h4>
                </div>

                <div class="abilityModAns">
                    <h4 class="newBuildStatAns"><?php echo $row['STRENGTH'] ?>%</h4>
                    <h4 class="newBuildStatAns"><?php echo $row['DURATION'] ?>%</h4>
                    <h4 class="newBuildStatAns"><?php echo $row['EFFICIENCY'] ?>%</h4>
                    <h4 class="newBuildStatAns"><?php echo $row['RANGE'] ?>%</h4>
                </div>

                <!-- Stats -->

                <div class="statModDesc">
                    <h4 class="newBuildStatDesc">Health</h4>
                    <h4 class="newBuildStatDesc">Shields</h4>
                    <h4 class="newBuildStatDesc">Armor</h4>
                    <h4 class="newBuildStatDesc">Energy</h4>
                </div>

                <div class="statModAns">
                    <h4 class="newBuildStatAns"><?php echo $row['HEALTH'] ?></h4>
                    <h4 class="newBuildStatAns"><?php echo $row['SHIELD'] ?></h4>
                    <h4 class="newBuildStatAns"><?php echo $row['ARMOR'] ?></h4>
                    <h4 class="newBuildStatAns"><?php echo $row['ENERGY'] ?></h4>
                </div>

                <div class="statModDesc2">
                    <h4 class="newBuildStatDesc">Gender</h4>
                    <h4 class="newBuildStatDesc">Sprint Speed</h4>
                    <h4 class="newBuildStatDesc">Damage Reduction</h4>
                    <h4 class="newBuildStatDesc">Effective Hit Points</h4>
                </div>

                <div class="statModAns2">
                    <h4 class="newBuildStatAns"><?php echo $row['SEX'] ?></h4>
                    <h4 class="newBuildStatAns"><?php echo $row['SPRINT'] ?></h4>
                    <h4 class="newBuildStatAns"><?php echo number_format((floatval($row['ARMOR']) / (floatval($row['ARMOR']) + 300) * 100), 2); ?>%</h4>
                    <h4 class="newBuildStatAns">
                        <?php
                            $armor = floatval($row['ARMOR']);
                            $health = floatval($row['HEALTH']);
                            $shield = floatval($row['SHIELD']);

                            $armorMultiplier = ($armor / ($armor + 300)) + 1;
                            $effectiveHealth = ($armorMultiplier * $health) + ($shield * 1.5);

                            echo number_format($effectiveHealth, 2);
                        ?>
                    </h4>
                </div>

            </div>

            <div class="comments">


                <!-- <div class="mod-grid">
                    <div class="mod-slot aura-slot" title="Aura Mod Slot">Aura</div>

                    <div class="mod-slot exilus-slot" title="Exilus Mod Slot">Exilus</div>

                    <div class="mod-slot">Mod 1</div>
                    <div class="mod-slot">Mod 2</div>
                    <div class="mod-slot">Mod 3</div>
                    <div class="mod-slot">Mod 4</div>
                    <div class="mod-slot">Mod 5</div>
                    <div class="mod-slot">Mod 6</div>
                    <div class="mod-slot">Mod 7</div>
                    <div class="mod-slot">Mod 8</div>
                </div> -->
            </div>
</form>

        <?php include("assets/includes/footer.html"); ?>
    </body>
</html>